Attribute VB_Name = "mdCreateRectangle"
'	This is a part of the source code for Pro/DESKTOP.
'	Copyright (C) 1999 Parametric Technology Corporation.
'	All rights reserved.


Rem Convenience Function to create a rectangle given the bottom left corner point (lowerBoundX,lowerBoundY)
'and the top right corner point (upperBoundX,upperBoundY)

Function CreateRectangle(lowerBoundX As Double, lowerBoundY As Double, upperBoundX As Double, upperBoundY As Double)

Rem To get the global objects like application, part, workplane, sketch
GetApplicationObject

Dim Part As PartDocument
Set Part = app.GetActiveDoc

Dim wp As aWorkplane
Set wp = Part.GetActiveWorkplane

Dim sketch As aSketch
Set sketch = Part.GetActiveSketch

Rem To create a rectangle from the given inputs
Dim length As Double
Dim breadth As Double
length = upperBoundX - lowerBoundX
breadth = upperBoundY - lowerBoundY

Dim point(4) As zVector
Set point(0) = app.GetClass("Vector").CreateVector(lowerBoundX, lowerBoundY, 0)
Set point(1) = app.GetClass("Vector").CreateVector(lowerBoundX + length, lowerBoundY, 0)
Set point(2) = app.GetClass("Vector").CreateVector(lowerBoundX + length, lowerBoundY + breadth, 0)
Set point(3) = app.GetClass("Vector").CreateVector(lowerBoundX, lowerBoundY + breadth, 0)

Dim obset As ObjectSet
Set obset = app.GetClass("ObjectSet").CreateAObjectSet

Dim line(4) As aLine

For I = 0 To 3
    Dim straight1 As zStraight
    Set straight1 = app.GetClass("BasicStraight").CreateBasicStraightTwoPoints(wp.Get3DVector(point(I)), wp.Get3DVector(point((I + 1) Mod 4)))
    Set line(I) = sketch.CreateLine(straight1)
    obset.AddMember line(I)
Next I

wp.AutoConstrain obset

Set CreateRectangle = obset

End Function

